/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.nodemgr.NoSuchNodesException;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.TaskContainerFreeSpace;
import oracle.ops.verification.framework.engine.task.sTaskFreeSpace;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUAutoUpdateManager;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskFreeSpace
extends TaskContainerFreeSpace {
    Vector<String> m_locations;
    String m_nodeFreeSpc;
    String m_mountPoint;
    Vector<StorageSize> m_reqdLocSize;
    StorageSize m_reqdMntSize;
    Vector<StorageSize> m_reqdRimLocSize;
    StorageSize m_reqdRimMntSize;
    StorageSize m_availMntSize;
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1056", false);

    public TaskFreeSpace(Vector<String> locations, String node, String mountPoint, Vector<StorageSize> reqdSize, StorageSize mntSize, Vector<StorageSize> reqdRimSize, StorageSize rimMntSize, StorageSize availSize) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        this.m_locations = locations;
        this.m_nodeFreeSpc = node;
        this.m_mountPoint = mountPoint;
        this.m_reqdLocSize = reqdSize;
        this.m_reqdMntSize = mntSize;
        this.m_reqdRimLocSize = reqdRimSize;
        this.m_reqdRimMntSize = rimMntSize;
        this.m_availMntSize = availSize;
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)this.toString());
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
    }

    @Override
    public String[] getNodeList() {
        String[] nodeList = new String[]{this.m_nodeFreeSpc};
        return nodeList;
    }

    public void adjustFreeSpace(double multiplier) {
        Trace.out((int)1, (String)("m_reqdMntSize before: '" + this.m_reqdMntSize.toString() + "'"));
        this.m_reqdMntSize.modify(multiplier);
        Trace.out((int)1, (String)("m_reqdMntSize after: '" + this.m_reqdMntSize.toString() + "'"));
    }

    public void setFreeSpace(StorageSize newsize) {
        Trace.out((int)1, (String)("m_reqdMntSize before: '" + this.m_reqdMntSize.toString() + "'"));
        this.m_reqdMntSize = newsize;
        Trace.out((int)1, (String)("m_reqdMntSize after: '" + this.m_reqdMntSize.toString() + "'"));
    }

    @Override
    public boolean performTask() {
        String nstatus;
        ErrorDescription errDesc;
        String loc;
        int i;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        if (this.hasRunBefore()) {
            this.refreshAvailableSize(this.m_mountPoint);
        }
        if (Trace.isLevelEnabled((int)5)) {
            String[] sizes = new String[this.m_reqdLocSize.size()];
            for (int j = 0; j < this.m_reqdLocSize.size(); ++j) {
                StorageSize size = this.m_reqdLocSize.elementAt(j);
                sizes[j] = ReportUtil.unitizeSize(size, 1);
            }
            Trace.out((String)("\n\n Performing Task for: " + this.toString()));
        }
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{CONSTRAINT_NAME, this.getDisplayLocations(this.m_nodeFreeSpc, this.m_locations)}));
        NodeManager nm = null;
        boolean bigCluster = false;
        List<Object> rimNodeList = null;
        try {
            NodeManagerFactory nmf = NodeManagerFactory.getInstance();
            nm = nmf.getNodeManager();
            bigCluster = nm.isBigCluster();
            if (bigCluster) {
                rimNodeList = Arrays.asList(nm.getNodes(NodeRoleCapability.RIM));
            }
        }
        catch (NodeManagerFactoryException e) {
            Trace.out((String)("NodeManagerFactoryException :" + e.getMessage()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            ReportUtil.printError(e.getMessage());
            return false;
        }
        catch (NoSuchNodesException e) {
            rimNodeList = new ArrayList();
        }
        catch (NodeManagerException e) {
            Trace.out((String)("NodeManagerFactoryException :" + e.getMessage()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            ReportUtil.printError(e.getMessage());
            return false;
        }
        ReportUtil.writeColHeaders(ReportUtil.PATH, ReportUtil.NODENAME, ReportUtil.MNTPNT, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.STATUS);
        if (this.m_mountPoint.contentEquals("UNKNOWN")) {
            GlobalExecution globalExec = new GlobalExecution();
            sTaskFreeSpace sTask = new sTaskFreeSpace(this);
            ResultSet rsltSet = new ResultSet();
            String[] parentNodeList = new String[]{this.m_nodeFreeSpc};
            Vector<String> succNodes = new Vector<String>();
            Vector<String> failNodes = new Vector<String>();
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("\nThere are " + this.m_locations.size() + " locations to process."));
            }
            block5: for (i = 0; i < this.m_locations.size(); ++i) {
                String loc2;
                boolean found = false;
                String newLoc = loc2 = this.m_locations.elementAt(i);
                String saveLoc = null;
                while (!found) {
                    if (VerificationUtil.pathExists(parentNodeList, newLoc, 0, succNodes, failNodes)) {
                        if (!VerificationUtil.isDirPathWritable(parentNodeList, newLoc, succNodes, failNodes)) break;
                        found = true;
                        break;
                    }
                    saveLoc = newLoc;
                    if (-1 != newLoc.lastIndexOf(FSEP)) {
                        newLoc = newLoc.substring(0, newLoc.lastIndexOf(FSEP));
                    }
                    if (newLoc.length() == 0) {
                        newLoc = new String(FSEP);
                    }
                    if (!saveLoc.contentEquals(newLoc)) continue;
                }
                if (!found) {
                    Trace.out((String)("Location: " + loc2 + " or Parent location: " + newLoc + " does not exist on node: " + this.m_nodeFreeSpc));
                    continue;
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\nProcessing old location: " + loc2 + "\ninto new location: " + newLoc));
                }
                String cmd = sTask.getCommand(newLoc);
                NativeSystem nativeSystem = new SystemFactory().CreateSystem();
                if (nativeSystem.isUnixSystem()) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\nExecuting command: " + cmd));
                    }
                    globalExec.runGenericCmd(parentNodeList, cmd, rsltSet);
                } else {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\nRunning exectask command : exectask -getspaceavail " + newLoc));
                    }
                    globalExec.getSpaceCmd(parentNodeList, newLoc, rsltSet);
                }
                Hashtable t = rsltSet.getResultTable();
                Enumeration e = t.keys();
                while (e.hasMoreElements()) {
                    String node = (String)e.nextElement();
                    Result result = (Result)t.get(node);
                    if (result.getStatus() != 1) continue;
                    String cmdOut = VerificationUtil.strArr2List((String[])result.getResultInfoSet().get(1), System.getProperty("line.separator"));
                    String sizeTxt = sTask.getData(cmdOut, 4);
                    this.m_mountPoint = sTask.getData(cmdOut, 6);
                    this.m_availMntSize = new StorageSize(new Double(sizeTxt), StorageUnit.MBYTE);
                    if (!Trace.isLevelEnabled((int)5)) continue block5;
                    Trace.out((String)("\nNEW Parent path Processing:  \n    Node:        " + node + "\n    Location:    " + loc2 + "\n    Size:        " + sizeTxt + "\n    Mount Point: " + this.m_mountPoint));
                    continue block5;
                }
            }
        }
        StorageSize reqdMntSize = this.m_reqdMntSize;
        if (bigCluster && rimNodeList.contains(this.m_nodeFreeSpc)) {
            reqdMntSize = this.m_reqdRimMntSize;
        }
        CollectionElement collectionElement = new CollectionElement(this.getElementName(), null, this.m_reqdMntSize, null, this.getDefaultDescription(), 5);
        this.m_resultSet.addCollectionElement(this.m_nodeFreeSpc, collectionElement);
        if (this.m_mountPoint.contentEquals("UNKNOWN")) {
            for (i = 0; i < this.m_locations.size(); ++i) {
                loc = this.m_locations.elementAt(i);
                errDesc = new ErrorDescription(s_msgBundle.getMessage("4001", true, (Object[])new String[]{loc}), s_msgBundle, "4001");
                this.m_resultSet.addResult(this.m_nodeFreeSpc, 2);
                this.m_resultSet.addErrorDescription(errDesc);
            }
            nstatus = ReportUtil.FAILED;
            collectionElement.setStatus(2);
        } else {
            if (this.m_availMntSize.compareTo(reqdMntSize) >= 0) {
                this.m_resultSet.addResult(this.m_nodeFreeSpc, 1);
                nstatus = ReportUtil.PASSED;
                collectionElement.setStatus(1);
            } else {
                this.m_resultSet.addResult(this.m_nodeFreeSpc, 3);
                for (i = 0; i < this.m_locations.size(); ++i) {
                    loc = this.m_locations.elementAt(i);
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7501", true, (Object[])new String[]{loc, this.m_nodeFreeSpc, ReportUtil.unitizeSize(reqdMntSize, 1)}), s_msgBundle, "7501");
                    this.m_resultSet.addErrorDescription(errDesc);
                }
                nstatus = ReportUtil.FAILED;
                collectionElement.setStatus(3);
            }
            this.m_resultSet.getResult(this.m_nodeFreeSpc).setHasResultValues(true);
            this.m_resultSet.getResult(this.m_nodeFreeSpc).setExpectedValue(ReportUtil.unitizeSize(reqdMntSize, 1));
            this.m_resultSet.getResult(this.m_nodeFreeSpc).setActualValue(ReportUtil.unitizeSize(this.m_availMntSize, 1));
            collectionElement.setValue(ReportUtil.unitizeSize(this.m_availMntSize));
            collectionElement.setExpectedValue(ReportUtil.unitizeSize(reqdMntSize));
        }
        for (i = 0; i < this.m_locations.size(); ++i) {
            loc = this.m_locations.elementAt(i);
            String availSize = null;
            availSize = this.m_mountPoint.contentEquals("UNKNOWN") && this.m_availMntSize.sizeIn(StorageUnit.KBYTE) == 0.0 ? "NOTAVAIL" : ReportUtil.unitizeSize(this.m_availMntSize, 1);
            ReportUtil.writeRecord(loc, this.m_nodeFreeSpc, this.m_mountPoint, availSize, ReportUtil.unitizeSize(reqdMntSize, 1), nstatus);
            if (!Trace.isLevelEnabled((int)5)) continue;
            Trace.out((String)("\n\n    Node:      " + this.m_nodeFreeSpc + "\n    Location:  " + loc + "\n    Available: " + availSize + "\n    Required:  " + ReportUtil.unitizeSize(reqdMntSize, 1) + "\n\n"));
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{CONSTRAINT_NAME, this.getDisplayLocations(this.m_nodeFreeSpc, this.m_locations)}));
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"Exit");
            }
            return true;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{CONSTRAINT_NAME, this.getDisplayLocations(this.m_nodeFreeSpc, this.m_locations)}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return false;
    }

    private void refreshAvailableSize(String loc) {
        NativeSystem nativeSystem;
        GlobalExecution globalExec = new GlobalExecution();
        sTaskFreeSpace sTask = new sTaskFreeSpace(this);
        String cmd = sTask.getCommand(loc);
        ResultSet rsltSet = new ResultSet();
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("\n\n    Executing command: " + cmd + "\n    on node:      " + this.m_nodeFreeSpc));
        }
        if ((nativeSystem = new SystemFactory().CreateSystem()).isUnixSystem()) {
            globalExec.runGenericCmd(new String[]{this.m_nodeFreeSpc}, cmd, rsltSet);
        } else {
            globalExec.getSpaceCmd(new String[]{this.m_nodeFreeSpc}, loc, rsltSet);
        }
        Hashtable t = rsltSet.getResultTable();
        Enumeration e = t.keys();
        Result result = (Result)t.get(this.m_nodeFreeSpc);
        if (result == null || result.getStatus() == 2) {
            this.m_availMntSize = new StorageSize(0.0, StorageUnit.BYTE);
            this.m_mountPoint = "UNKNOWN";
        } else {
            String cmdOut = VerificationUtil.strArr2List((String[])result.getResultInfoSet().get(1), System.getProperty("line.separator"));
            String sizeTxt = sTask.getData(cmdOut, 4);
            this.m_availMntSize = new StorageSize(new Double(sizeTxt), StorageUnit.MBYTE);
        }
        if (ParamManager.isRuncluvfy()) {
            this.bootStrapSizeAdjustment();
        }
    }

    private void bootStrapSizeAdjustment() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry bootStrapSizeAdjustment()..");
        }
        Trace.out((String)"In bootStrapSizeAdjustment..");
        String localNode = null;
        try {
            localNode = VerificationUtil.getLocalHost();
            if (localNode.equals(this.m_nodeFreeSpc)) {
                this.m_localNode = VerificationUtil.getLocalHost();
                String bootStrapPath = CVUAutoUpdateManager.getDerivedCVUHome();
                String mntPnt = this.getMntPnt(bootStrapPath);
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("\nMount Point " + mntPnt + "\n" + "Location   " + bootStrapPath));
                }
                if (this.m_mountPoint.equals(mntPnt)) {
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)("    Before adding bootstrap size \n    Mount Point: " + this.m_mountPoint + "    Avail size : " + ReportUtil.unitizeSize(this.m_availMntSize, 1)));
                    }
                    this.addBootStrapSpace(bootStrapPath);
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)("    After adding bootstrap size \n    Mount Point: " + this.m_mountPoint + "    Avail size : " + ReportUtil.unitizeSize(this.m_availMntSize, 1)));
                    }
                }
            }
        }
        catch (UnknownHostException uhe) {
            Trace.out((String)uhe.getMessage());
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)" Exit ");
        }
    }

    public boolean addBootStrapSpace(String bsLoc) {
        VerificationCommand cmdOP;
        Result result;
        Trace.out((String)"Inside addBootStrapSpace().....");
        ResultSet rsltSet = new ResultSet();
        String[] arg = new String[]{"-getdirsize", bsLoc};
        String[] env = null;
        VerificationCommand[] cmd = new VerificationCommand[]{new VerificationCommand(this.m_localNode, arg, env)};
        boolean cmdResult = new GlobalHandler().submit((Command[])cmd, 0, rsltSet);
        if (cmdResult && (result = (Result)rsltSet.getResultTable().get(this.m_localNode)).getStatus() == 1 && (cmdOP = cmd[0]).getVfyCode() == 0) {
            String cmdOut = cmdOP.getOutput();
            if (cmdOut == null) {
                return false;
            }
            String[] op = (cmdOut = cmdOut.trim()).split("\n");
            if (op.length > 0) {
                cmdOut = op[0];
            }
            StorageSize sizeAvail = new StorageSize(new Double(cmdOut), StorageUnit.BYTE);
            this.m_availMntSize.add(sizeAvail);
            return true;
        }
        return false;
    }

    public String getLocations() {
        return this.getDisplayLocations(this.m_nodeFreeSpc, this.m_locations);
    }

    private String getDisplayLocations(String node, Vector<String> location) {
        StringBuffer strBuf = new StringBuffer("");
        if (location != null) {
            boolean first = true;
            for (int i = 0; i < location.size(); ++i) {
                if (location.elementAt(i) == null) continue;
                if (first) {
                    first = false;
                } else {
                    strBuf.append(",");
                }
                strBuf.append(node + ":" + location.elementAt(i));
            }
        }
        return strBuf.toString();
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4408", false) + ": " + this.getDisplayLocations(this.m_nodeFreeSpc, this.m_locations);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4458", false);
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer("");
        String[] sizes = new String[this.m_reqdLocSize.size()];
        for (int i = 0; i < this.m_reqdLocSize.size(); ++i) {
            StorageSize size = this.m_reqdLocSize.elementAt(i);
            sizes[i] = ReportUtil.unitizeSize(size, 1);
        }
        strBuf.append("\n\n    Location: " + this.getDisplayLocations(this.m_nodeFreeSpc, this.m_locations) + "\n    Node: " + this.m_nodeFreeSpc + "\n    Mount Point: " + this.m_mountPoint + "\n    Size(s): " + VerificationUtil.strArr2List(sizes) + "\n    Total Size: " + ReportUtil.unitizeSize(this.m_reqdMntSize, 1) + "\n    Avail Size: " + ReportUtil.unitizeSize(this.m_availMntSize, 1) + "\n\n");
        return strBuf.toString();
    }
}

